import argparse, os, glob, numpy as np
from pathlib import Path

def stats(a):
    return dict(shape=list(a.shape), dtype=str(a.dtype), min=float(np.min(a)), max=float(np.max(a)), mean=float(np.mean(a)), std=float(np.std(a)))

def main():
    ap=argparse.ArgumentParser()
    ap.add_argument('--root', required=True, help='data/inputs root')
    ap.add_argument('--limit', type=int, default=20)
    args=ap.parse_args()
    paths=glob.glob(os.path.join(args.root,'*','L*','b*','k*','f*','seed*','E0.npz'))
    print('found',len(paths),'E0 files')
    c=0
    for p in sorted(paths)[:args.limit]:
        try:
            with np.load(p) as z:
                key=list(z.keys())[0]
                a=z[key]
            st=stats(a)
            print(p, st)
        except Exception as e:
            print('[ERR]',p,e)
        c+=1
    
if __name__=='__main__':
    main()
